/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.cache.texture;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.common.cache.texture.AnimatableTexture;
import mod.azure.azurelib.common.cache.texture.AzAbstractTexture;
import mod.azure.azurelib.common.cache.texture.GeoGlowingTextureMeta;
import mod.azure.azurelib.common.platform.Services;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1084;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4573;
import org.jetbrains.annotations.Nullable;

public class AutoGlowingTexture
extends AzAbstractTexture {
    protected final class_2960 textureBase;
    protected final class_2960 glowLayer;

    public AutoGlowingTexture(class_2960 originalLocation, class_2960 location) {
        super(originalLocation);
        this.textureBase = originalLocation;
        this.glowLayer = location;
    }

    @Override
    @Nullable
    protected class_4573 loadTexture(class_3300 resourceManager, class_310 mc) throws IOException {
        AnimatableTexture animatableTexture;
        boolean animated;
        class_1011 class_10112;
        class_1044 originalTexture;
        try {
            originalTexture = (class_1044)mc.method_5385(() -> mc.method_1531().method_4619(this.textureBase)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException("Failed to load original texture: " + String.valueOf(this.textureBase), e);
        }
        class_3298 textureBaseResource = (class_3298)resourceManager.method_14486(this.textureBase).get();
        if (originalTexture instanceof class_1043) {
            class_1043 dynamicTexture = (class_1043)originalTexture;
            class_10112 = dynamicTexture.method_4525();
        } else {
            class_10112 = class_1011.method_4309((InputStream)textureBaseResource.method_14482());
        }
        class_1011 baseImage = class_10112;
        class_1011 glowImage = null;
        Optional textureBaseMeta = textureBaseResource.method_14481().method_43041((class_3270)class_1084.field_5344);
        boolean blur = textureBaseMeta.isPresent() && ((class_1084)textureBaseMeta.get()).method_4696();
        boolean clamp = textureBaseMeta.isPresent() && ((class_1084)textureBaseMeta.get()).method_4697();
        try {
            Optional glowLayerResource = resourceManager.method_14486(this.glowLayer);
            GeoGlowingTextureMeta glowLayerMeta = null;
            if (glowLayerResource.isPresent()) {
                glowImage = class_1011.method_4309((InputStream)((class_3298)glowLayerResource.get()).method_14482());
                if (baseImage.method_4307() != glowImage.method_4307() || baseImage.method_4323() != glowImage.method_4323()) {
                    AzureLib.LOGGER.error("Glowmask size mismatch with base texture. Base size: {}x{}, Glowmask size: {}x{}, Location: {}", (Object)baseImage.method_4307(), (Object)baseImage.method_4323(), (Object)glowImage.method_4307(), (Object)glowImage.method_4323(), (Object)this.glowLayer);
                    return null;
                }
                glowLayerMeta = GeoGlowingTextureMeta.fromExistingImage(glowImage);
            } else {
                Optional meta = textureBaseResource.method_14481().method_43041(GeoGlowingTextureMeta.DESERIALIZER);
                if (meta.isPresent()) {
                    glowLayerMeta = (GeoGlowingTextureMeta)meta.get();
                    glowImage = new class_1011(baseImage.method_4307(), baseImage.method_4323(), true);
                }
            }
            if (glowLayerMeta != null) {
                glowLayerMeta.createImageMask(baseImage, glowImage);
                if (Services.PLATFORM.isDevelopmentEnvironment()) {
                    this.printDebugImageToDisk(this.textureBase, baseImage);
                    this.printDebugImageToDisk(this.glowLayer, glowImage);
                }
            }
        }
        catch (IOException e) {
            AzureLib.LOGGER.warn("Resource failed to open for glowlayer meta: {}", (Object)this.glowLayer, (Object)e);
        }
        class_1011 mask = glowImage;
        if (mask == null) {
            String expectedGlowmask = this.textureBase.toString().replace(".png", "_glowmask.png");
            AzureLib.LOGGER.warn("Missing glowmask texture. Base texture: {}, Expected glowmask: {}", (Object)this.textureBase, (Object)expectedGlowmask);
            return null;
        }
        boolean bl = animated = originalTexture instanceof AnimatableTexture && (animatableTexture = (AnimatableTexture)originalTexture).isAnimated();
        if (animated) {
            ((AnimatableTexture)originalTexture).animationContents.animatedTexture.setGlowMaskTexture(this, baseImage, mask);
        }
        return () -> {
            if (!animated) {
                AutoGlowingTexture.uploadSimple(this.method_4624(), mask, blur, clamp);
            }
            if (originalTexture instanceof class_1043) {
                class_1043 dynamicTexture = (class_1043)originalTexture;
                dynamicTexture.method_4524();
            } else {
                AutoGlowingTexture.uploadSimple(originalTexture.method_4624(), baseImage, blur, clamp);
            }
        };
    }
}

